//=============================================================================
// DisplayMessage
//
// Can display a fancy or not-so-fancy message when triggered
//
// Uses code from Alex's MMShowMessage
//=============================================================================
Class DisplayMessage extends MPConvo_Trigger;

var(MPC_Message) string dMessage;
var(MPC_Message) bool bFancyMessage;

//----------------------------------------
// Replication
//----------------------------------------
replication 
{ 
	reliable if (Role == ROLE_Authority) 
		ConvMessage; 
}

function DoCoolStuff(DeusExPlayer Instigator)
{
	if(bFancyMessage == true)
	{
		ConvMessage(Instigator, dMessage);
	}
	else
	{
		Instigator.ClientMessage(dMessage);
	}
}

simulated function ConvMessage(DeusExPlayer P, string Message)
{
	local HUDMissionStartTextDisplay _HUD;

	if((P.RootWindow != None) && (DeusExRootWindow(P.RootWindow).HUD != None))
	{
		_HUD = DeusExRootWindow(P.RootWindow).HUD.startDisplay;
	}

	if(_HUD != None) 
	{ 
		_HUD.shadowDist = 0; 
		_HUD.Message = ""; 
		_HUD.charIndex = 0; 
		_HUD.winText.SetText(""); 
		_HUD.winTextShadow.SetText(""); 
		_HUD.displayTime = 5.50; 
		_HUD.perCharDelay = 0.30; 
		_HUD.AddMessage(Message); 
		_HUD.StartMessage(); 
	}
}

defaultproperties
{
     dMessage
}